#ifndef rl_Traits_h_INCLUDED
#define rl_Traits_h_INCLUDED

// File:   rl_Traits.h
// Author: Terry Gaetz

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006, 2007 Smithsonian Astrophysical Observatory
 *
 * This file is part of rl_raylib
 *
 * rl_raylib is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * rl_raylib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

/****************************************************************************
 * 0.0.0 1998-Jun-24  tjg  original version
 */

// #ifndef   std_complex_dbl_h_INCLUDED
// #include <std_complex_dbl/std_complex_dbl.h>
// #endif

#include <complex>

//########################################################################
// rl_Traits
//########################################################################
//

/** 
 * \class rl_Traits
 *
 * rl_Traits is a ``traits'' class for the rl_RayLib library.
 * It defines typedefs (e.g., abstracting out the complex class)
 * and enums used in the library.  It also declares a 
 * Plain Old Data (POD) struct to encapsulate the dielectric constant data.
 */

class rl_Traits
{
public:

  /// Typedef for the complex type
  // typedef std_complex_dbl complex;
  typedef std::complex<double> complex;

  /// Typedef for the Boolean type
  enum Bool { False, True };

  /**
   * Enumeration specifying the interpolation of the optical constants.
   */
  enum EInterpMode 
  { 
    ELinLin,    /**< linear in energy, linear in optical constants. */
    ELinLog,    /**< log    in energy, linear in optical constants. */
    ELogLin,    /**< linear in energy, log    in optical constants. */
    ELogLog     /**< log    in energy, log    in optical constants. */
  };

  /**
   * Enumeration specifying the type of interlayer diffusion treatment
   */
  enum ERoughType
  {
    ERoughNone,                /**< no interlayer diffusion */
    ERoughDebyeWaller_RSAO,    /**< Debye-Waller factor */
    ERoughDebyeWaller_CSAO,    /**< Debye-Waller factor */
    ERoughDebyeWaller_Spiller, /**< Debye-Waller factor */
    ERoughModifiedDebyeWaller, /**< Modified Debye-Waller factor */
    ERoughNevotCroce           /**< Nevot-Croce factor */
  };

   /*! \struct rl_DielectricPOD 
    *  Plain Ol' Data:  dielectric data (alpha, gamma) as a function of energy.
    */
  struct rl_DielectricPOD
  {
    /// energy (keV)
    double energy_;
    /// dielectric decrement, real part
    double alpha_;
    /// dielectric decrement, imag part
    double gamma_;
  };
};

/* rl_Traits_h_INCLUDED */
#endif
