#ifndef   spline_coef_h_INCLUDED
#define   spline_coef_h_INCLUDED

/* spline_coef.h -- spline deformation parameters & data
 *
 * Note:  see documentation for DASL routine B2VPRE
 */

#if 0
!---  max values for spline parameters...

      integer     MX_z_order           ! max order of z splines
      integer     MX_theta_order           ! max order of theta splines
      integer     MX_ORDR             ! max of MX_z_order, MX_theta_order
      integer     MX_MTHETA           ! number of thetas to eval spline at
      integer     MX_MTHETA1          ! MX_MTHETA + 1

      integer     MX_QZ               ! max QZ
      integer     MX_num_theta_knots           ! max num_theta_knots

      parameter ( MX_z_order  =  4 )
      parameter ( MX_theta_order  =  4 )
      parameter ( MX_ORDR    =  4 )    ! max(MX_z_order, MX_z_order)

      parameter ( MX_MTHETA  =  1 )
      parameter ( MX_MTHETA1 =  MX_MTHETA + 1 )

      parameter ( MX_QZ      = 450 )
      parameter ( MX_num_theta_knots  = 300 )

!---  declaration of spline variables...
#endif

typedef struct
{
  /*--------------------------------------------------------------------
   * spline knot location information
   */
  double  zmin;            /* lower endpoint of z-interval              */
  double  zmax;            /* upper endpoint of z-interval              */
  double  tmin;            /* lower endpoint of theta-interval          */
  double  tmax;            /* upper endpoint of theta-interval          */

  double* z_knots;         /* interior z-knotlines                      */
  double* t_knots;         /* interior theta-knotlines                  */

  double  c_rms_amplitude; /* rms of deformations                       */

  /*--------------------------------------------------------------------
   * b-spline coefficients:  1st subscript relates to z...
   * NB:  flat storage, fortran (column-major) order)
   */
  double* c;               /* c              [n_theta_knots *  qz]      */
  double* cdifz;           /* dc/d(z)        [n_theta_knots * (qz-1)]   */
  double* cdift;           /* dc/d(theta)    [n_theta_knots *  qz]      */

  /*--------------------------------------------------------------------
   * spline order in each direction
   */
  size_t     z_order;         /* order (degree + 1) of spline s in z       */
  size_t     theta_order;     /* order (degree + 1) of spline s in theta   */

  /*--------------------------------------------------------------------
   * number of knots in each direction
   */
  size_t     qz;              /* num_z_knots + z_order,  where num_z_knots */
                              /* is number of interior z-knotlines         */
  size_t     num_z_knots;     /* number of interior z-knotlines            */
  size_t     num_theta_knots; /* number of interior theta-knotlines        */

} spline_coef;

#endif
