#ifndef SUPLIB_KEYVAL_H
#define SUPLIB_KEYVAL_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of suplib
 *
 * suplib is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * suplib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#include <stddef.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
  Key_String,
  Key_Integer,
  Key_Float,
  Key_Double,
  Key_Boolean
} KeyType;

typedef struct KeyVal
{
  char *key;		/* keyword name */
  KeyType type;		/* keyword type */
  size_t offset;		/* offset of value */
  int set;
  int (*xfrm)( char *in, void *out );
} KeyVal;

#define KeyValStEntry( name, type, target ) { #name, type, offsetof( struct target , name ), 0, NULL }
typedef enum
{
  KeyValErr_OK = 0,		/* no error */
  KeyValErr_NOMEM,		/* out of memory */
  KeyValErr_NOKEY,		/* no such keyword */
  KeyValErr_UNBAL,		/* unbalanced quote or escape character */
  KeyValErr_INVAL,		/* invalid value specification */
  KeyValErr_RANGE,		/* the value is out of range */
  KeyValErr_MAXERR
} KeyValErr;

KeyValErr	keyval_st(const char * kv_spec, KeyVal * map, size_t nkey,
		       void *data, long *where);
int		keyval_cmp( const void *v1, const void *v2 );

void		keyval_perror(FILE *fout, KeyValErr error, const char* spec,
			      long where);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* ! SUPLIB_KEYVAL_H */
