.\" Automatically generated by Pod::Man 2.28 (Pod::Simple 3.29)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
.    ds C`
.    ds C'
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.\"
.\" Avoid warning from groff about undefined register 'F'.
.de IX
..
.nr rF 0
.if \n(.g .if rF .nr rF 1
.if (\n(rF:(\n(.g==0)) \{
.    if \nF \{
.        de IX
.        tm Index:\\$1\t\\n%\t"\\$2"
..
.        if !\nF==2 \{
.            nr % 0
.            nr F 2
.        \}
.    \}
.\}
.rr rF
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "validate.inplace l"
.TH validate.inplace l "2016-09-06" " " " "
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
validate.inplace \- validate elements in a data structure during assignment
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
.Vb 3
\&  \-\- load packages
\&  va = require(\*(Aqvalidate.args\*(Aq)
\&  vi = require(\*(Aqvalidate.inplace\*(Aq )
\&
\&  \-\- define a validation specification (see docs for validate.args)
\&  spec = { foo = { type = \*(Aqposint\*(Aq } }
\&
\&  \-\- construct the inplace validation object
\&  vio = vi:new( \*(Aqtest\*(Aq, spec, va:new() )
\&
\&  \-\- create a more user friendly table to play with
\&  test = vio:proxy()
\&
\&  \-\- assign something that\*(Aqs legal.
\&  test.foo = 3
\&
\&  \-\- assign something that\*(Aqs not legal; this\*(Aqll throw an error
\&  test.foo = \-3
\&
\&  \-\- use the value
\&  if 3 == test.foo then print ("3!" ) end
\&
\&  \-\- create an independent standard Lua data structure
\&  copy = vio:copy()
.Ve
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBvalidate.inplace\fR makes it easy to provide instantaneous feedback to
users when they assign an incorrect value to an element in a data
structure.
.PP
Traditional validation of data occurs after a data structure has
been created and passed into a validation routine.  At that point the
user can only be notified of which element in the data structure is
invalid.  It'd be much more useful if the user was notified of where
in their \fIcode\fR the error was made.
.PP
This class creates a proxy data structure which allows the validation
of elements upon assignment to them.
.PP
Validation is performed by \fBvalidate.args\fR.
.SS "Usage"
.IX Subsection "Usage"
.IP "1." 4
Create a validation specification table (see the \fBvalidate.args\fR
docs).  As this is a validation of a table, only named elements can be
validated, so the specification table will look like
.Sp
.Vb 2
\&  spec = { name_of_elem1 = { spec for elem1 },
\&           name_of_elem2 = { sepc for elem2 } }
.Ve
.IP "2." 4
Create a \fBvalidate.args\fR validation object and customize it as
necessary:
.Sp
.Vb 1
\&  vao = require( \*(Aqvalidate.args\*(Aq):new()
.Ve
.IP "3." 4
Create the \fBvalidate.inplace\fR object:
.Sp
.Vb 1
\&  vio = vi:new( \*(Aqconfig\*(Aq, spec, vao )
.Ve
.IP "4." 4
Retrieve and expose the proxy data structure:
.Sp
.Vb 1
\&  config = vio:proxy();
.Ve
.PP
At this point \f(CW\*(C`config\*(C'\fR is a Lua table which can be assigned to and
read from.  However, none of the Lua functions used to traverse a
table (such as \fBpair\fR, \fBnext\fR, etc) will be of much use.  To use
those you'll need to make a copy of the table (using the \fB\f(BIcopy()\fB\fR
method) and traverse the copy.
.SS "Methods"
.IX Subsection "Methods"
.IP "new" 4
.IX Item "new"
.Vb 1
\&  obj = vi:new( name, spec, vao )
.Ve
.Sp
Create a \fBvalidate.inplace\fR object.  This object administers the
storage and validation of the data, as well as the proxy data structure
presented to the user.
.Sp
The following parameters are required:
.RS 4
.IP "name" 4
.IX Item "name"
The name assigned to the root of the data structure, used in error
messages.  Typically this is the name of the table to which the top
level proxy table will be assigned (via the \fB\f(BIproxy()\fB\fR method):
.Sp
.Vb 2
\&  vio = vi:new( \*(Aqconfig\*(Aq, spec, va:new() )
\&  config = vio:proxy()
.Ve
.IP "spec" 4
.IX Item "spec"
This is a \fBvalidate.args\fR validation specification table.  Its
structure must follow the \*(L"named argument layout\*(R" structure
as documented in the \fBvalidate.args\fR docs.
.IP "vao" 4
.IX Item "vao"
This is a \fBvalidate.args\fR object.  It is used along with the
specification to validate elements.
.RE
.RS 4
.RE
.IP "proxy" 4
.IX Item "proxy"
.Vb 1
\&  table = vio:proxy()
.Ve
.Sp
This returns a table to which data may be written to and read from.
As it is a proxy, attempts to traverse it will be unfulfilling.
.IP "copy" 4
.IX Item "copy"
.Vb 1
\&  copy = vio:copy()
.Ve
.Sp
Create a copy of the data structure managed by the \fBvalidate.inplace\fR
object.  Unlike the structure returned by the \fB\f(BIproxy()\fB\fR method, the
structure returned by \fB\f(BIcopy()\fB\fR may be traversed using the standard
Lua functions.  Changes to it will not be reflected in the data stored
in the \fBvalidate.inplace\fR object (nor will changes in the object
change this data structure).
.SH "LIMITATIONS"
.IX Header "LIMITATIONS"
.SS "Unsupported \fBvalidate.args\fP features"
.IX Subsection "Unsupported validate.args features"
.IP "\(bu" 4
\&\fBvalidate.inplace\fR cannot handle specifications which use \fBvtable\fR
functions or mutating validation specifications.
.IP "\(bu" 4
\&\f(CW\*(C`precall\*(C'\fR and \f(CW\*(C`postcall\*(C'\fR functions are called only for non-table
data elements.  This has not been extensively tested, so don't rely
upon them.
.SS "Performance"
.IX Subsection "Performance"
This class is not built for speed.  It imposes significant overhead
when both setting and retrieving elements within a data structure. It
was designed for validation of configuration data which is typically
done once.
.PP
Some of things that happen under the hood:
.IP "1." 4
\&\fBvalidate.args\fR is invoked whenever a value is set
.IP "2." 4
The data structure uses proxy tables to track accesses to the data.
.IP "3." 4
Assignment of a nested data structure to an element requires a recursive
descent through the nested table if some or all levels of the nested
structure are to be validated.
.PP
To improve read performance, use the \fB\f(BIcopy()\fB\fR method to create a
non-proxied version of the data structure.  It will be detached from
the proxied version (so changes to either will not be reflected in the
other).
.SH "AUTHOR"
.IX Header "AUTHOR"
Diab Jerius, <djerius@cfa.harvard.edu>
.SH "COPYRIGHT AND LICENSE"
.IX Header "COPYRIGHT AND LICENSE"
Copyright (C) 2011 by the Smithsonian Astrophysical Observatory
.PP
This software is released under the \s-1GNU\s0 General Public License.
You may find a copy at <http://www.fsf.org/copyleft/gpl.html>.
