#ifndef SUPLIB_STR_H
#define SUPLIB_STR_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of suplib
 *
 * suplib is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * suplib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct
{
  const char *name;
  int   id;
} TokListToken;

typedef struct
{
  TokListToken *toks;
  size_t ntoks;
} TokList;

#define GenTokList(tokens) {(tokens), sizeof(tokens) / sizeof(TokListToken)}


#define STRTOK_SKIP    0x01
#define STRTOK_RESTORE 0x02
#define STRTOK_ESCAPE  0x04

struct str_tokbqdata
{
  char dchar;
  char *ptr;
  char *start_match;
};


char *	str_dup( const char *string );
char *	str_join(const char *delim, size_t n, ... );
char *	str_prune(char *str);
char *	str_rep( char *str, int c_old, int c_new );

int	str_varscan(const char *string,
		    void (*callback)(const char*, const char*,
				     const char*, const char*, void*),
		    void *udata, const char **errptr);

char *  str_interp(const char *text, int  keep_undef,
		   const char **ustart, const char **uend, int *error );

int  str_tokenize( char* string, const char* delim, char*** string_argv,
		  int skip, int restore );
void str_tokenize_free( char** string_argv, int restore );


size_t	str_tokcnt( const char *string, const char *delim );

char *	str_tokq(char *string, const char *delim, int skip,
		 int restore, char **ptr, char *dchar);
int	str_tokqcnt(char *string, const char *delim, int skip);
char *  str_tokq_restore(char *ptr, char dchar);


struct str_tokbqdata *str_tokbq_init(struct str_tokbqdata * tbqd);
void	str_tokbq_free(struct str_tokbqdata * tbqd);

void	str_tokbqenize_free(char** string_argv, int action);

int	str_tokbqenize(char* string, char*** string_argv, const char* delim,
		       const char* open_quote, const char* close_quote,
		       char escape_char, int actions,
		       struct str_tokbqdata * tbqd, int* error);

char *  str_tokbq(char* string, const char* delim,
		  const char* open_quote, const char* close_quote,
		  char escape_char, int actions,
		  struct str_tokbqdata *, int* error);

int	str_tokbqcnt(char* string, const char* delim,
		  const char* open_quote, const char* close_quote,
		  char escape_char, int actions,
		  struct str_tokbqdata *, int* error);

char *	str_tokbq_restore(struct str_tokbqdata *tqbd);


char *	str_trim( char *str );
char *	str_trunc( char *str );
size_t	str_dtokcnt( const char *string, char *delim );
size_t	str_dtoksplit(char *str, char *tok[], const char *delim, int ntok);

int	tokmatch(const char *token, const TokList *toklist );
int	tokcmp(const void *tok1, const void *tok2);
int	tokcasematch(const char *token, const TokList *toklist );
int	tokcasecmp(const void *tok1, const void *tok2);

int	tokqsplit(char *str, char *tok[], const char *delim, int ntok,
		  int split);
int	toksplit(char *str, char *tok[], const char *delim, int ntok);

char *	unescape( char *string );

char *	unquote(char *string);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* ! SUPLIB_STR_H */
