#ifndef FULLRAY_H
#define FULLRAY_H

/*H**************************************************************************
 *
 * Source     : ray.h
 * Author     : M. Freeman
 * Version    : 0.0.2
 * Date Begun : 93-___-__ [M. Freeman]
 * Last Rev   : 93-Nov-05 [T. Gaetz]
 * Id String  : $Id$
 *
 * Description: declare FULLRAY struct for binary piped OSAC
 *
 * History:
 *    931105[tjg]: rename to fullray.h; remove some typedefs
 *    931027[tjg]: split polar into c2, s2; add documentation on polarization
 *
 *H*/

/*--- Complex struct -------------------------------------------------*/

#include <bpipe/datatypes.h>   /* use bpipe's version, to make sure
				  everyone agrees */

/*--- Basic ray ------------------------------------------------------*/

typedef struct {
  double r[3];  /* position                */
  double v[3];  /* direction (unit vector) */
} rayset;

/*--- Full ray struct ------------------------------------------------*/

#define MAX_GRAZE 2

typedef struct {
    rayset pos;               /* 6 doubles (3 pos, 3 dir cosines)          */
    double norm[3];           /* surf normal, most recent reflection       */
    double wt;                /* statistical weight of ray                 */
    double g_ang[MAX_GRAZE];  /* sine(grazing angle), surfaces 1 and 2     */
    double energy;            /* photon energy                             */
    double path;              /* optical path length                       */
    dcomplex c2[2];           /* polarization amplitude (cosine component) */
    dcomplex s2[2];           /* polarization amplitude (sine component)   */
    int id;                   /* ray identifier (index)                    */
    int handy[3];             /* useful ints (eg. ring & spoke no.)        */
                              /*    (ring no, spoke no, ray kode)          */
} fullray;

/* 
 * polarization state:   relation to OSAC polarization vectors
 *
 *      c2[0] <--> c2comp(1),   c2[1] <--> c2comp(2),   
 *      s2[0] <--> s2comp(1),   s2[1] <--> s2comp(2)
 *
 *   random polarization:
 *       wt =   c2[0].r^2 + c2[1].r^2 + c2[0].i^2 + c2[1].i^2 
 *            + s2[0].r^2 + s2[1].r^2 + s2[0].i^2 + s2[1].i^2 
 *
 *   discrete polarization:
 *       wt =   c2[0].r^2 + c2[1].r^2 + c2[0].i^2 + c2[1].i^2 
 *            + s2[0].r^2 + s2[1].r^2 + s2[0].i^2 + s2[1].i^2 
 *            + c2[0].i s2[0].r + c2[1].i s2[1].r
 *            - c2[0].r s2[0].i - c2[1].r s2[1].i
 */


#endif /* FULLRAY_H ------------------- END OF FILE -----------------------*/
