.\" Automatically generated by Pod::Man 4.10 (Pod::Simple 3.35)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
.    ds C`
.    ds C'
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is >0, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.\"
.\" Avoid warning from groff about undefined register 'F'.
.de IX
..
.nr rF 0
.if \n(.g .if rF .nr rF 1
.if (\n(rF:(\n(.g==0)) \{\
.    if \nF \{\
.        de IX
.        tm Index:\\$1\t\\n%\t"\\$2"
..
.        if !\nF==2 \{\
.            nr % 0
.            nr F 2
.        \}
.    \}
.\}
.rr rF
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "trace-shell l"
.TH trace-shell l "2020-09-24" " " " "
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
trace\-shell \- ray trace a shell, hey!
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBtrace-shell\fR \fIoptions\fR
.SH "ARGUMENTS"
.IX Header "ARGUMENTS"
\&\fBtrace-shell\fR uses an IRAF-compatible parameter interface. The
available parameters are:
.IP "\fBtag\fR" 8
.IX Item "tag"
A prefix to be used on all intermediate files created.  There are lots
of intermediate files; see the section on \*(L"Intermediate Files\*(R".
.IP "\fBsrc\fR" 8
.IX Item "src"
The location of a \fBraygen\fR compatible source script.  If it is the
string \f(CW\*(C`default\*(C'\fR, the value of the \f(CW\*(C`source_spec\*(C'\fR keyword in the
\&\fBtrace-shell\fR configuration file is used.
.IP "\fBsrcpars\fR" 8
.IX Item "srcpars"
Extra parameters to be passed to the source script.  If it ends in
\&\f(CW\*(C`.lua\*(C'\fR it is interpreted as being the name of a Lua script. See the
documentation for the source script for information on which
parameters are available.
.IP "\fBoutput\fR" 8
.IX Item "output"
The output stream to which to write the rays.  It may be a filename,
or the string \f(CW\*(C`stdout\*(C'\fR, in which case rays will be written to the
standard output stream.  If it is the string \f(CW\*(C`default\*(C'\fR, a file name
will be created by appending the \fBoutput_fmt\fR to the \fBtag\fR (with an
intervening period).
.IP "\fBoutput_fmt\fR" 8
.IX Item "output_fmt"
The output format of the rays.  May be one of \f(CW\*(C`fr\*(C'\fR, \f(CW\*(C`bpipe\*(C'\fR, \f(CW\*(C`rdb\*(C'\fR,
or a \f(CW\*(C`fits\*(C'\fR variant.  See \*(L"Output Formats\*(R" for more information.
.IP "\fBoutput_coord\fR" 8
.IX Item "output_coord"
The output coordinate system of the rays.  May be one of \f(CW\*(C`osac\*(C'\fR,
\&\f(CW\*(C`hrma\*(C'\fR, \f(CW\*(C`xrcf\*(C'\fR.
.IP "\fBoutput_fields\fR" 8
.IX Item "output_fields"
Which data fields to output for each ray.  The value may be one of
.RS 8
.ie n .IP """all""" 4
.el .IP "\f(CWall\fR" 4
.IX Item "all"
A rather large amount of information.
.IP "<field names>" 4
.IX Item "<field names>"
A comma delimited list of field names to output.  Field names may be
prefixed with \f(CW\*(C`\-\*(C'\fR, indicating that they are to be \fIremoved\fR from the
list of output fields.  If the only fields specified are those to be
removed, the initial output list contains all of the fields in the data.
.Sp
The field name \f(CW\*(C`min\*(C'\fR is an alias for specifying the following fields:
.Sp
.Vb 1
\&  position direction weight energy time
.Ve
.Sp
The order of additive and subtractive fields is unimportant; all additive
fields are inserted into the list before the subtractive fields are removed.
.RE
.RS 8
.RE
.IP "\fBshell\fR" 8
.IX Item "shell"
The shell to raytrace.
.IP "\fBseed1\fR" 8
.IX Item "seed1"
The first seed for the random number generator.  It must be in the range
[1,2147483562].
.IP "\fBseed2\fR" 8
.IX Item "seed2"
The second seed for the random number generator.  It must be in the range
[1,214748339]
.IP "\fBblock\fR" 8
.IX Item "block"
The random number block at which to start.  It must be in the range
[0,1048575].
.IP "\fBblock_inc\fR" 8
.IX Item "block_inc"
The spacing between random number blocks for each random process.  100
is a good number.
.IP "\fBtstart\fR" 8
.IX Item "tstart"
The start time of the observation in seconds.  If less than zero and
jitter is turned on, the start of the valid jitter time range is used.
.IP "\fBlimit\fR" 8
.IX Item "limit"
The quantity of whatever \f(CW\*(C`limit_type\*(C'\fR specifies that \fBraygen\fR must
generate.  If \f(CW\*(C`limit_type\*(C'\fR is a unit of time, this is added to the
start time (see \f(CW\*(C`tstart\*(C'\fR) to determine the stop time of the
simulation. If jitter is on and this is set to \f(CW0\fR, then the stop
time is set equal to the end of the valid jitter time range.
.IP "\fBlimit_type\fR" 8
.IX Item "limit_type"
The units of the limit at which to stop generating rays.
.RS 8
.ie n .IP """ksec""" 8
.el .IP "\f(CWksec\fR" 8
.IX Item "ksec"
kiloseconds of observation time
.ie n .IP """sec""" 8
.el .IP "\f(CWsec\fR" 8
.IX Item "sec"
seconds of observation time
.ie n .IP """Mrays""" 8
.el .IP "\f(CWMrays\fR" 8
.IX Item "Mrays"
millions of rays at the entrance aperture
.ie n .IP """krays""" 8
.el .IP "\f(CWkrays\fR" 8
.IX Item "krays"
thousands of rays at the entrance aperture
.ie n .IP """rays""" 8
.el .IP "\f(CWrays\fR" 8
.IX Item "rays"
rays at the entrance aperture
.ie n .IP """r/mm2""" 8
.el .IP "\f(CWr/mm2\fR" 8
.IX Item "r/mm2"
a ray density at the entrance aperture in rays / mm^2
.ie n .IP """r/cm2""" 8
.el .IP "\f(CWr/cm2\fR" 8
.IX Item "r/cm2"
a ray density at the entrance aperture in rays / cm^2
.RE
.RS 8
.RE
.IP "\fBfocus\fR" 8
.IX Item "focus"
A boolean parameter indicating that the focus of the system is to be
determined.  See the \*(L"Focus\*(R" section for more details.
.IP "\fBz\fR" 8
.IX Item "z"
The position along the \fIZ\fR (optical) axis at which to leave the rays.
.IP "\fBtally\fR" 8
.IX Item "tally"
If non-zero, a tally of photons will be written to the standard
error stream every \f(CW\*(C`tally\*(C'\fR rays.  This is useful if you're wondering
why it's taking so long to run the raytrace.  This tallies the number
of rays which make it out of the shell, after all of the post-optic
apertures.
.IP "\fBconfig_dir\fR" 8
.IX Item "config_dir"
\&\fBtrace-shell\fR will change into this directory before reading
the configuration file.  This allows relative includes within
standard configuration files to work.
.IP "\fBconfig_db\fR" 8
.IX Item "config_db"
The name of the configuration file which provides the details of the
mirror configuration.  If this begins with \f(CW\*(C`.\*(C'\fR or \f(CW\*(C`/\*(C'\fR, the
configuration file in the specified directory will be used.  Note that
\&\fBtrace-shell\fR will still change directory to \fBconfig_dir\fR before
reading the configuration file.
.IP "\fBversion\fR" 8
.IX Item "version"
Print out the version information and exit.
.IP "\fBhelp\fR" 8
.IX Item "help"
Print out this message and exit.
.IP "\fBdebug\fR" 8
.IX Item "debug"
A comma separated list of debugging options.  See \*(L"Debugging\*(R"
for more information.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBtrace-shell\fR raytraces a single Wolter type I X\-ray telescope
shell with various apertures and baffles.  It was designed around the
\&\s-1AXAF HRMA,\s0 but may be used for other systems.  In order to isolate the
source specification from the specification of the optics, it uses a
separate optics configuration file (see \*(L"Configuration File\*(R").
.PP
\&\fBtrace-shell\fR uses a variety of programs to accomplish the
raytrace.  To see the actual raytrace command pipeline, use the
\&\fBdebug\fR \f(CW\*(C`pcomm\*(C'\fR option.
.SS "Configuration File"
.IX Subsection "Configuration File"
The \fBtrace-shell\fR configuration file (specified by the
\&\fBconfig_dir\fR and \fBconfig_db\fR parameters) describes the telescope
configuration. See the \fBts_config\fR documentation for more information.
.SS "Intermediate Files"
.IX Subsection "Intermediate Files"
\&\fBtrace-shell\fR produces a few intermediate files, prefixed by the
value of the \fBtag\fR parameter:
.ie n .IP """tag.gi""" 8
.el .IP "\f(CWtag.gi\fR" 8
.IX Item "tag.gi"
This is a rather arcanely formatted file required by \fBSAOdrat\fR.  It's not of
much general interest.
.ie n .IP """tag.tot_wt.in.log""" 8
.el .IP "\f(CWtag.tot_wt.in.log\fR" 8
.IX Item "tag.tot_wt.in.log"
This file contains the number and weight of the rays at the entrance aperture.
It is produced by \fBtot_wt\fR.
.ie n .IP """tag.tot_wt.out.log""" 8
.el .IP "\f(CWtag.tot_wt.out.log\fR" 8
.IX Item "tag.tot_wt.out.log"
This file contains the number and weight of the rays which have made it through
the entire configuration.  It is produced by \fBtot_wt\fR.
.ie n .IP """tag.focus.log""" 8
.el .IP "\f(CWtag.focus.log\fR" 8
.IX Item "tag.focus.log"
This is an arcanely formatted file created during a focus run by
\&\fBsaofocus\fR.
.ie n .IP """tag.summary.rdb""" 8
.el .IP "\f(CWtag.summary.rdb\fR" 8
.IX Item "tag.summary.rdb"
This summarizes the \f(CW\*(C`tag.tot_wt.in.log\*(C'\fR, \f(CW\*(C`tag.tot_wt.out.log\*(C'\fR, and \f(CW\*(C`tag.focus.log\*(C'\fR
files.
.SS "Output Formats"
.IX Subsection "Output Formats"
\&\fBtrace-shell\fR produces output in one of the following formats,
specified by the \fBoutput_fmt\fR parameter:
.ie n .IP """fr""" 8
.el .IP "\f(CWfr\fR" 8
.IX Item "fr"
The \f(CW\*(C`fr\*(C'\fR format has no header.  Each ray is in a \f(CW\*(C`fullray\*(C'\fR structure.
See \fI/proj/axaf/simul/include/fullray.h\fR for the formats of the ray
structure.
.ie n .IP """bpipe""" 8
.el .IP "\f(CWbpipe\fR" 8
.IX Item "bpipe"
The rays are in \f(CW\*(C`bpipe\*(C'\fR format. See the \fBbpipe\fR documentation for
more information on this.
.ie n .IP """rdb""" 8
.el .IP "\f(CWrdb\fR" 8
.IX Item "rdb"
The rays are written as an \s-1RDB\s0 table.
.ie n .IP "a ""fits"" variant" 8
.el .IP "a \f(CWfits\fR variant" 8
.IX Item "a fits variant"
Various \s-1FITS\s0 formatted outputs may be specified.  In all cases the
output must be to a file.
.RS 8
.ie n .IP """fits\-axaf""" 4
.el .IP "\f(CWfits\-axaf\fR" 4
.IX Item "fits-axaf"
The rays are written according to the \s-1AXAF FITS\s0 Photon standard.
.ie n .IP """fits\-events""" 4
.el .IP "\f(CWfits\-events\fR" 4
.IX Item "fits-events"
The rays are written in the common astronomical X\-ray
\&\*(L"events\*(R" format.  Most X\-ray Astronomy software uses this convention.
.RE
.RS 8
.RE
.SS "Focus"
.IX Subsection "Focus"
If you wish to determine where the focal point for a given
configuration is, set the \fBfocus\fR parameter to \f(CW\*(C`yes\*(C'\fR.  Because of
bad interactions between the focus algorithm and wildly scattered
rays, micro-roughness induced ray scattering and ghost-ray tracking is
turned off when focussing.  You should nominally only focus with a
point source.  If the \fBsrc\fR parameter is set to \f(CW\*(C`default\*(C'\fR, the
default focus source (as specified in the configuration file) will be
used.  You may need to specify arguments for the focus source via the
\&\fBsrcpars\fR parameter. The focus procedure is carred out by
\&\fBsaofocus\fR which leaves its results in files called \f(CW\*(C`tag.focus.log\*(C'\fR
and \f(CW\*(C`tag.focus.rdb\*(C'\fR (where you've specified \fBtag\fR).  The first file's
format is pretty arcane; generally to extract the focus from there, run the
script \fIgetfocus\fR on it:
.PP
.Vb 1
\&  getfocus tag.focus.log
.Ve
.PP
which will write out the focal position (in \s-1OSAC\s0 coordinates) to the
standard output stream.  The second file (\f(CW\*(C`tag.focus.rdb\*(C'\fR) contains
the three-dimensional position of the Global Optimal Focus.
.SS "Debugging"
.IX Subsection "Debugging"
The \fBdebug\fR options that are available are:
.ie n .IP """pcomm""" 8
.el .IP "\f(CWpcomm\fR" 8
.IX Item "pcomm"
Print out the raytrace command before executing it.  This gives you
some idea of which programs are running and what their inputs are.
.ie n .IP """noexec""" 8
.el .IP "\f(CWnoexec\fR" 8
.IX Item "noexec"
Generate the raytrace command and any required intermediate files, but
do not execute it.  Most useful with the \f(CW\*(C`pcomm\*(C'\fR debug option.
.ie n .IP """reuse""" 8
.el .IP "\f(CWreuse\fR" 8
.IX Item "reuse"
Reuse the raytrace output from a previous \fBidentical\fR run to
regenerate the summary information.  \f(CW\*(C`noexec\*(C'\fR must \fInot\fR be
specified simultaneously.  The raytrace parameters should be
identical except for the addition of this flag.
.ie n .IP """normalize_limit""" 8
.el .IP "\f(CWnormalize_limit\fR" 8
.IX Item "normalize_limit"
If specified and the \f(CW\*(C`limit_type\*(C'\fR parameter is density related, the
output ray weights will be scaled so that the input photon density is
1.  This allows specifying different photon densities for each shell
to provide a uniform statistical errors while retaining the ability to
easily coadd the raytraces for different shells.
.ie n .IP """noproject""" 8
.el .IP "\f(CWnoproject\fR" 8
.IX Item "noproject"
Do not project the rays to the value specified by the \f(CW\*(C`z\*(C'\fR parameter.
This is a temporary kludge, and will probably not survive into the
next version of \fBtrace-shell\fR.
.ie n .IP """save\-rays"":\fIlocation\fR" 8
.el .IP "\f(CWsave\-rays\fR:\fIlocation\fR" 8
.IX Item "save-rays:location"
.PD 0
.ie n .IP """save\-history"":\fIlocation\fR" 8
.el .IP "\f(CWsave\-history\fR:\fIlocation\fR" 8
.IX Item "save-history:location"
.PD
\&\f(CW\*(C`save\-rays\*(C'\fR and \f(CW\*(C`save\-history\*(C'\fR are complementary means of getting a
look at the rays as they pass through the raytrace.
.RS 8
.IP "\(bu" 4
\&\f(CW\*(C`save\-rays\*(C'\fR will create a copy of the current state of the rays on disk.
Save intermediate rays. Rays are saved in \f(CW\*(C`bpipe\*(C'\fR format to the file
\&\fI${tag}.where.bp\fR.
.IP "\(bu" 4
\&\f(CW\*(C`save\-history\*(C'\fR will store a copy of the current state of the rays in
the ray stream.  It does this by changing every data packet field into an
array, and using it as a stack; newer data is at index 0; the oldest
is at the end of the array.  To limit the number of fields which have
history, use the \f(CW\*(C`save\-history\-fields\*(C'\fR debug option.
.RE
.RS 8
.Sp
There are a number of pre-defined locations in the raytrace at which ray history
may be saved.  Multiple locations may be specified. Use the format
.Sp
.Vb 2
\&  save\-rays:location1,save\-rays:location2,...
\&  save\-history:location1,save\-history:location2,...
.Ve
.Sp
\&\fIlocation\fR is one of
.IP "input" 4
.IX Item "input"
Rays coming out of the ray generator
.IP "h\-pre-intercept" 4
.IX Item "h-pre-intercept"
.PD 0
.IP "p\-pre-intercept" 4
.IX Item "p-pre-intercept"
.PD
Rays before they are intercepted with the optic.
.IP "h\-post-intercept" 4
.IX Item "h-post-intercept"
.PD 0
.IP "p\-post-intercept" 4
.IX Item "p-post-intercept"
.PD
Rays after they are intercepted with the optic.
.IP "h\-pre-reflect" 4
.IX Item "h-pre-reflect"
.PD 0
.IP "p\-pre-reflect" 4
.IX Item "p-pre-reflect"
.PD
Rays before they are reflected at the optic.
.IP "h\-post-reflect" 4
.IX Item "h-post-reflect"
.PD 0
.IP "p\-post-reflect" 4
.IX Item "p-post-reflect"
.PD
Rays after they are reflected at the optic.
.IP "h\-pre-scatter" 4
.IX Item "h-pre-scatter"
.PD 0
.IP "p\-pre-scatter" 4
.IX Item "p-pre-scatter"
.PD
Rays before they are scattered off of the optic
.IP "h\-post-scatter" 4
.IX Item "h-post-scatter"
.PD 0
.IP "p\-post-scatter" 4
.IX Item "p-post-scatter"
.PD
Rays after they are scattered off of the optic
.RE
.RS 8
.RE
.ie n .IP """save\-history\-fields""=\fIcolon separated list of fields\fR" 8
.el .IP "\f(CWsave\-history\-fields\fR=\fIcolon separated list of fields\fR" 8
.IX Item "save-history-fields=colon separated list of fields"
By default, saving history (see the \f(CW\*(C`save\-history\*(C'\fR debug option)
saves \fIall\fR fields.  This can be expensive.  To limit the number of
fields saved, set this option to a \fIcolon\fR separated list of fields:
.Sp
.Vb 1
\&  save\-history\-fields=position:direction:id
.Ve
.ie n .IP """input\-tap""=\fIcommand\fR" 8
.el .IP "\f(CWinput\-tap\fR=\fIcommand\fR" 8
.IX Item "input-tap=command"
The rays exiting the ray generator (before they hit the shells) will
be copied to the standard input stream of the specified command (thus
the name \f(CW\*(C`input\-tap\*(C'\fR).  The command may refer to any of the
parameters given to \fBtrace-shell\fR using the syntax \f(CW$parameter\fR or
\&\f(CW\*(C`${parameter}\*(C'\fR.  For example,
.Sp
.Vb 1
\&  debug=input\-tap=\*(Aqfrobnicator input=stdin output=$tag.frob\*(Aq
.Ve
.Sp
The rays are in \fBbpipe\fR format.
.ie n .IP """input\-filter""=\fIcommand\fR" 8
.el .IP "\f(CWinput\-filter\fR=\fIcommand\fR" 8
.IX Item "input-filter=command"
The rays exiting the ray generator are passed through the provided
command before being sent to the shells.  The command must read the
rays from its standard input and write the modified rays to its
standard output.  The command may refer to any of the parameters given
to \fBtrace-shell\fR using the syntax \f(CW$parameter\fR or \f(CW\*(C`${parameter}\*(C'\fR.
For example,
.Sp
.Vb 1
\&  debug=input\-filter=\*(Aqsnackmaster input=stdin output=stdout\*(Aq
.Ve
.Sp
The rays are in \fBbpipe\fR format.
.ie n .IP """noghosts""" 8
.el .IP "\f(CWnoghosts\fR" 8
.IX Item "noghosts"
Ghost rays will not be propagated through the system.
.ie n .IP """output\-tap""=\fIcommand\fR" 8
.el .IP "\f(CWoutput\-tap\fR=\fIcommand\fR" 8
.IX Item "output-tap=command"
The rays exiting the optics (after projecting to the final
requested position, but before any coordinate conversions) will
be copied to the standard input stream of the specified command (thus
the name \f(CW\*(C`output\-tap\*(C'\fR).  The command may refer to any of the
parameters given to \fBtrace-shell\fR using the syntax \f(CW$parameter\fR or
\&\f(CW\*(C`${parameter}\*(C'\fR.  For example,
.Sp
.Vb 1
\&  debug=output\-tap=\*(Aqfrobnicator input=stdin output=$tag.frob\*(Aq
.Ve
.Sp
The rays are in \fBbpipe\fR format.
.ie n .IP """output\-filter""=\fIcommand\fR" 8
.el .IP "\f(CWoutput\-filter\fR=\fIcommand\fR" 8
.IX Item "output-filter=command"
The rays exiting the optics (after projecting to the final requested
position, but before any coordinate conversions) are passed through
the provided command before being tallied and finally written to the
requested destination. The command must read the rays from its
standard input and write the modified rays to its standard output.
The command may refer to any of the parameters given to
\&\fBtrace-shell\fR using the syntax \f(CW$parameter\fR or \f(CW\*(C`${parameter}\*(C'\fR.
For example,
.Sp
.Vb 1
\&  debug=output\-filter=\*(Aqsnackmaster input=stdin output=stdout\*(Aq
.Ve
.Sp
The rays are in \fBbpipe\fR format.
.ie n .IP """scat_min_prob""=\fIfractional probability\fR" 8
.el .IP "\f(CWscat_min_prob\fR=\fIfractional probability\fR" 8
.IX Item "scat_min_prob=fractional probability"
.PD 0
.ie n .IP """scat_max_prob""=\fIfractional probability\fR" 8
.el .IP "\f(CWscat_max_prob\fR=\fIfractional probability\fR" 8
.IX Item "scat_max_prob=fractional probability"
.PD
set the minimum or maximum scattering probability for both optics
.ie n .IP """scat_min_prob_${optic}""=\fIfractional probability\fR" 8
.el .IP "\f(CWscat_min_prob_${optic}\fR=\fIfractional probability\fR" 8
.IX Item "scat_min_prob_${optic}=fractional probability"
.PD 0
.ie n .IP """scat_max_prob_${optic}""=\fIfractional probability\fR" 8
.el .IP "\f(CWscat_max_prob_${optic}\fR=\fIfractional probability\fR" 8
.IX Item "scat_max_prob_${optic}=fractional probability"
.PD
set the minimum or maximum scattering probability for the specified
optic.  The string \fI\f(CI$optic\fI\fR may be one of \f(CW\*(C`p\*(C'\fR or \f(CW\*(C`h\*(C'\fR.
.ie n .IP """scat_in_plane""=""yes""|""no""" 8
.el .IP "\f(CWscat_in_plane\fR=\f(CWyes\fR|\f(CWno\fR" 8
.IX Item "scat_in_plane=yes|no"
.PD 0
.ie n .IP """scat_out_of_plane""=""yes""|""no""" 8
.el .IP "\f(CWscat_out_of_plane\fR=\f(CWyes\fR|\f(CWno\fR" 8
.IX Item "scat_out_of_plane=yes|no"
.PD
Turn on or off in or out-of-plane scattering for both optics.  The
default is taken from the raytrace configuration file.
.ie n .IP """scat_in_plane_${optic}""=""yes""|""no""" 8
.el .IP "\f(CWscat_in_plane_${optic}\fR=\f(CWyes\fR|\f(CWno\fR" 8
.IX Item "scat_in_plane_${optic}=yes|no"
.PD 0
.ie n .IP """scat_out_of_plane_${optic}""=""yes""|""no""" 8
.el .IP "\f(CWscat_out_of_plane_${optic}\fR=\f(CWyes\fR|\f(CWno\fR" 8
.IX Item "scat_out_of_plane_${optic}=yes|no"
.PD
Turn on or off in or out-of-plane scattering for the specified
optic.  The string \fI\f(CI$optic\fI\fR may be one of \f(CW\*(C`p\*(C'\fR or \f(CW\*(C`h\*(C'\fR.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fBtrace-nest\fR, \fBts_config\fR
.SH "COPYRIGHT AND LICENSE"
.IX Header "COPYRIGHT AND LICENSE"
Copyright 2006 The Smithsonian Astrophysical Observatory
.PP
This software is released under the \s-1GNU\s0 General Public License.  You
may find a copy at: <http://www.fsf.org/copyleft/gpl.html>
.SH "AUTHOR"
.IX Header "AUTHOR"
Diab Jerius <djerius@cfa.harvard.edu>
