#!/bin/sh
# set -x

LC_NUMERIC=en_US.ISO8859-1
export LC_NUMERIC

files="None"
while [ x"$1" != x ]; do
    case $1 in
	-file)
            files="$2"
	    shift
	    shift
	    continue;;
	*)  
            break;;
    esac
done

if [ x"$1" = xgnuplot ]; then

  if [ x`which gnuplot 2>/dev/null` = x ]; then
    echo "ERROR: gnuplot not available"
    exit 1
  fi
  gawk '
  BEGIN{
    mode=1
    xlabel="unknown"
    ylabel="unknown"
    prev="noprev"
    ind=0
    plots=0
    counts = 0
    initparam=0
  }
  mode==1{
    if( initparam == 0 ){
      if( files == "None" ){
        files=""
        dofile="true"
      }
      else{
        dofile="false"
      }
      initparam=1
    }
    if( dofile == "true" && $1 == "#" && $2 == "data" && $3 == "file:" ){
      if( files != "" ) files = files ","
      files = files $4
    }
    else if( $1 == "#" && $2 == "radii:" ){
      xlabel = $3
    }
    else if( $1 == "#" && $2 == "surf_bri:" ){
      ylabel = $3
    }
    else if( $1 == "----" ){
      head = sprintf("set title \"funcnts(%s)\"\n", files)
      head = head sprintf("set xlabel \" radius(%s)\"\n", xlabel)
      head = head sprintf("set ylabel \"surf_bri(%s)\"\n", ylabel)
      head = head "plot "
      mode = 2
      next
    }
  }
  mode==2{
    if( NF == 12 ){
      if( $11 == prev ){
	ind += 1
      }
      else{
	ind = 1
        plots += 1
        i = (plots - 1) * 4 + 2
        if( plots > 1 )
          head = head ", "
        head = head sprintf("\"-\" using 1:%d:%d:%d:%d title \"profile #%d\" with boxerrorbars", i, i+1, i+2, i+3, plots)
      }
      if( data[ind] == "" )
        data[ind] = sprintf("%s", ($9+$10)/2)
      data[ind] = data[ind] sprintf(" %s %s %s %s", $7, $7-$8, $7+$8, $10-$9)
      counts += $7
      prev = $11
    }
    else{
      mode = 3
    }
  }
  END{
    if( counts == 0 ){
      exit 0
    }
    print head
    for(i=1; i<=plots; i++){
      for(j=1; j<=ind; j++){
        print data[j]
      }
      print "e"
    }    
  }
  ' files="$files" | gnuplot -persist - 1>/dev/null 2>&1
  exit 0

elif [ x"$1" = xds9 ]; then

  gawk '
  BEGIN{
    mode=1
    xlabel="unknown"
    ylabel="unknown"
    initparam=0
  }
  mode==1{
    if( initparam == 0 ){
      if( files == "None" ){
        files=""
        dofile="true"
      }
      else{
        dofile="false"
      }
      initparam=1
    }
    if( dofile == "true" && $1 == "#" && $2 == "data" && $3 == "file:" ){
      if( files != "" ) files = files ","
      files = files $4
    }
    else if( $1 == "#" && $2 == "radii:" ){
      xlabel = $3
    }
    else if( $1 == "#" && $2 == "surf_bri:" ){
      ylabel = $3
    }
    else if( $1 == "----" ){
      ds9header="'"${DS9_PLOT_HEADER}"'"
      if( ds9header != "" ) {
	  printf "%s 3\n", ds9header
      }
      else{
          printf "funcnts(%s) avg_radius(%s) surf_bri(%s) 3\n", files, xlabel, ylabel
      }
      mode = 2
      next
    }
  }
  mode==2{
    if( NF == 12 ){
      if( $9 != "NA" ){
        print ($9+$10)/2, $7, $8
      }
      else{
         print "ERROR: annulus, circle, panda regions only"
	 exit 1
#        print $7, "non-annulus-region", "specified!"
#        mode = 3
      }
    }
    else{
      mode = 3
    }
  }
  ' files="$files"
  exit 0
else

  echo "ERROR: unknown argument: " $1
  echo "funcnts -r ... | funcnts.plot [ds9|gnuplot]"
  exit 1

fi
